/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/

//===========================================================================================
//-- XML Loader For Entire Gallery
//===========================================================================================
var gallery_obj:Object = new Object();				// gallery object
var gallery_xml:XML = new XML();					// gallery xml
gallery_xml.ignoreWhite = true;

gallery_xml.onLoad = function(success:Boolean):Void {

	if (success) {
		var rootNode:XMLNode = this.firstChild;
		
		// start populating gallery object
		gallery_obj.numNodes 	= rootNode.childNodes.length;
		gallery_obj.imagePath 	= rootNode.attributes.galleryImagePath;
		gallery_obj.thumbPath 	= rootNode.attributes.galleryThumbPath;
		gallery_obj.gallery		= new Array();
		
		for (var n:Number = 0; n < gallery_obj.numNodes; n++) {
			gallery_obj.gallery[n] = new Object();
			gallery_obj.gallery[n].name 		= rootNode.childNodes[n].firstChild.firstChild.nodeValue;
			gallery_obj.gallery[n].buttonName	= rootNode.childNodes[n].firstChild.nextSibling.firstChild.nodeValue;
			gallery_obj.gallery[n].description 	= rootNode.childNodes[n].firstChild.nextSibling.nextSibling.firstChild.nodeValue;
			gallery_obj.gallery[n].xmlPath		= rootNode.childNodes[n].firstChild.nextSibling.nextSibling.nextSibling.firstChild.nodeValue;
		}
	
		galleryDisplayed = 0;
		library_xml.load(dirPath + "xml/" + gallery_obj.gallery[galleryDisplayed].xmlPath);
		
	} else {
		throwError("gallery failed to load. check XML path.");
	}
	
};


//===========================================================================================
//-- XML Loader For Individual Libraries
//===========================================================================================
var library_obj:Object = new Object();				// library object
var library_xml:XML = new XML();					// library xml
library_xml.ignoreWhite = true;

library_xml.onLoad = function(success:Boolean):Void {
	if (success) {

		var rootNode:XMLNode = this.firstChild;
		
		// start populating gallery object
		library_obj.numNodes 	= rootNode.childNodes.length;
		library_obj.libraryName	= rootNode.attributes.libName;
		library_obj.image		= new Array();

		// populate images into object array
		for (var i:Number = 0; i < library_obj.numNodes; i++) {
			library_obj.image[i] = new Object();
			library_obj.image[i].path = rootNode.childNodes[i].attributes.itemPath;
			library_obj.image[i].name = rootNode.childNodes[i].attributes.itemName;
			library_obj.image[i].desc = rootNode.childNodes[i].firstChild.firstChild.nodeValue;
		}
		
		buildLibrary();
		
	} else {
		throwError("xml document failed to load.");
	}
};